### 59.9. 理解Gradle插件是如何工作的

当`spring-boot`被应用到你的Gradle项目，一个默认的名叫`bootRepackage`的任务被自动创建。`bootRepackage`任务依赖于Gradle `assemble`任务，当执行时，它会尝试找到所有限定符为空的jar artifacts（也就是说，tests和sources jars被自动跳过）。

由于`bootRepackage`查找'所有'创建jar artifacts的事实，Gradle任务执行的顺序就非常重要了。多数项目只创建一个单一的jar文件，所以通常这不是一个问题。然而，如果你正打算创建一个更复杂的，使用自定义`jar`和`BootRepackage`任务的项目setup，有几个方面需要考虑。

如果'仅仅'从项目创建自定义jar文件，你可以简单地禁用默认的`jar`和`bootRepackage`任务：
```gradle
jar.enabled = false
bootRepackage.enabled = false
```
另一个选项是指示默认的`bootRepackage`任务只能使用一个默认的`jar`任务：
```gradle
bootRepackage.withJarTask = jar
```
如果你有一个默认的项目setup，在该项目中，主（main）jar文件被创建和重新打包。并且，你仍旧想创建额外的自定义jars，你可以将自定义的repackage任务结合起来，然后使用`dependsOn`，这样`bootJars`任务就会在默认的`bootRepackage`任务执行以后运行：
```gradle
task bootJars
bootJars.dependsOn = [clientBoot1,clientBoot2,clientBoot3]
build.dependsOn(bootJars)
```
上面所有方面经常用于避免一个已经创建的boot jar又被重新打包的情况。重新打包一个存在的boot jar不是什么大问题，但你可能会发现它包含不必要的依赖。
